<?php
/**
 * Plugin Name: OBS Woo Skroutz cart
 * Plugin URI:
 * Description: OBS WooCommerce Skroutz Cart
 * Version: 0.2
 * Author: OBS Technologies
 * Author URI: https://obstechnologies.gr/
 * License:
 * License URI:
 */

// Make sure we don't expose any info if called directly
if ( ! function_exists( 'add_action' ) ) {
	echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
	exit;
}

// Define version
define( 'OBS_WOO_API_EXT_VERSION', '0.1' );

class Obs_Woo_Api_Ext {
	private $url = "https://api.skroutz.gr/merchants/ecommerce/orders/";
	private $token = "";
	private $email = "";
	
	function __construct() {
		$this->token  = get_option('skroutzcart-api');
		$this->email  = get_option('skroutzcart-email');

		// Add action
		add_action( 'rest_api_init', function () {
			register_rest_route( 'obs/v1', '/smart_cart_orders', array(
				'methods'  => 'POST',
				'callback' => [ $this, 'handle_order' ],
			) );
		} );

		add_action( 'admin_menu', array($this,'skroutzcart_admin_menu') );

		add_action( 'admin_init', [$this,'register_skroutzcart_settings'] );
		add_filter( 'woocommerce_order_data_store_cpt_get_orders_query', [$this, 'handle_custom_query_var'], 10, 2 );
		add_action( 'add_meta_boxes', array( $this, 'skroutz_add_meta_boxes' ) );
		//add_action( 'woocommerce_update_order', array( $this, 'action_woocommerce_update_order'), 10, 1 );
		add_action('save_post', array($this,'update_skroutz'));
	}

	public function skroutzcart_admin_menu() {
        /* add new top level */
        add_menu_page(
            __( 'Skroutz Smart Cart', 'skroutzcart-woocommerce' ),
            __( 'Skroutz Smart Cart', 'skroutzcart-woocommerce' ),
            'manage_options',
            'skroutzcart_admin_menu',
            [$this,'skroutzcart_admin_page']
        );
    }

    public function skroutzcart_admin_page() {
        global $woocommerce;
    
    
        echo '<div class="wrap">';
    
        echo '<h1>'.__('Settings page for Skroutz Smart Cart', 'skroutzcart-woocommerce').'</h1><form method="post" action="options.php">';
        echo '<p>The url '.get_site_url().'/wp-json/obs/v1/smart_cart_orders</p>';
        settings_fields( 'skroutzcart-group' );
        do_settings_sections( 'skroutzcart-group' );
        echo '<table class="form-table">';
    
        echo '<tr valign="top">';
        echo '<th scope="row">'.__('API Key','geniki-woocommerce').'</th>';
        echo '<td><input type="text" name="skroutzcart-api" value="'.get_option('skroutzcart-api').'" /></td>';
        echo '</tr>';
    
        echo '<tr valign="top">';
        echo '<th scope="row">'.__('Demo email for skroutz cart orders','skroutzcart-woocommerce').'</th>';
        echo '<td><input type="text" name="skroutzcart-email" value="'.get_option('skroutzcart-email').'" /></td>';
        echo '</tr>';


        echo '</table>';
        submit_button(); 
        echo '</div>';
    
    }

    public function register_skroutzcart_settings() { // whitelist options 
        register_setting( 'skroutzcart-group', 'skroutzcart-api' );
        register_setting( 'skroutzcart-group', 'skroutzcart-email' );
    }
	
	function update_skroutz($order_id)
	{
		//approve
		$order = wc_get_order($order_id);
		if ($order) {
			$skroutzcode = $order->get_meta('skroutzcode');

			if (array_key_exists("pickup_window", $_POST) && $_POST["pickup_window"]) {
				//make request for approval
				$curl = curl_init();

				curl_setopt_array($curl, array(
				  CURLOPT_URL => "https://api.skroutz.gr/merchants/ecommerce/orders/".$skroutzcode."/accept",
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => "",
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 30,
				  CURLOPT_CUSTOMREQUEST => "POST",
					CURLOPT_SSL_VERIFYPEER => false,
				  CURLOPT_POSTFIELDS => $_POST,
				  CURLOPT_HTTPHEADER => array(
					"accept: application/vnd.skroutz+json; version=3.0",
					"authorization: Bearer ".$this->token
				  ),
				));

				$response = curl_exec($curl);
				$err = curl_error($curl);
				return $response;
			}
		}
	}

	
	function skroutz_add_meta_boxes() {
		add_meta_box( 'skroutz_order_fields', __( 'Skroutz Smart Cart', 'woocommerce-speedex-cep' ), array( $this, 'skroutz_cart_management_widget' ), 'shop_order', 'side', 'core' );
	}
	
	function get_skroutz_data ($skroutzcode) {
		if (defined('CURLOPT_IPRESOLVE') && defined('CURL_IPRESOLVE_V4')){
   
}
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);

		curl_setopt_array($curl, array(
		  CURLOPT_URL => "https://api.skroutz.gr/merchants/ecommerce/orders/".$skroutzcode,
		  CURLOPT_RETURNTRANSFER => true,
		  //CURLOPT_ENCODING => "",
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 300,
		  CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_SSL_VERIFYPEER => false,
		  CURLOPT_HTTPHEADER => array(
			"Accept: application/vnd.skroutz+json; version=3.0",
			"Authorization: Bearer ".$this->token
		  ),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);
        curl_close($curl);
		//print_r($response);
		return json_decode($response, true);
	}
	
	function skroutz_cart_management_widget() {
		global $post;
		$order        = wc_get_order( $post->ID );
		$skroutzcode = $order->get_meta( 'skroutzcode');
		if (!$skroutzcode) {
			echo "<p>Δεν ειναι παραγγελία απο Skroutz</p>";
		}  else {
			$response = $this->get_skroutz_data($skroutzcode);
			if ($response["order"]["state"] == "accepted") {
				echo "Κατεβάστε το voucher <a href=".$response["order"]["courier_voucher"]." target='_blank'>εδώ</a>";
				$datetime = $response["order"]["dispatch_until"];
				//print_r($response["order"]);
				date_default_timezone_set('Europe/Athens'); 
				$formatted = date('d/m/Y H:i', strtotime($datetime));
				$pieces = explode(" ", $formatted);
				$final_time = $pieces[0]." εώς ".$pieces[1];
				//echo "<p> Αναχώρηση ".$final_time."</p>";
			} else {
				$pickup_timeframe = $response["order"]["accept_options"]["pickup_window"];
				//print_r($pickup_timeframe);
				echo "<h2>Αποδοχή Παραγγελίας</h2>";
				echo "<input name='number_of_parcels' value=".$response["order"]["accept_options"]["number_of_parcels"][0] ." readonly>";
				echo "<input name='pickup_location' value=".$response["order"]["accept_options"]["pickup_location"][0]["id"] ." readonly>";
				echo "<select name='pickup_window'>";
					echo "<option value=''>-- Επιλέξτε --</option>";
				
				foreach ($pickup_timeframe as $time) {
					echo "<option value=".$time["id"]." >";
					echo $time["label"];
					echo "</option>";

				}
				echo "</select>";
			}
			
			
		}

	}

	function create_order ($data) {
		$firstname = $data["customer"]["first_name"];
		$lastname = $data["customer"]["last_name"];
		
		$address = array(
			'first_name' => 'SKROUTZ ΕΞΥΠΝΟ ΚΑΛΑΘΙ '.$firstname,
			'last_name'  => $lastname,
			'company'    => 'Skroutz',
			'email'      => $this->email,
			'phone'      => '2152154227',
			'address_1'  => $data["customer"]["address"]["street_name"]." ".$data["customer"]["address"]["street_number"],
			'city'       => $data["customer"]["address"]["city"],
			'state'      => $data["customer"]["address"]["region"],
			'postcode'   => $data["customer"]["address"]["zip"],
			'country'    => 'GR'
		);

		$order = wc_create_order();

		$items = $data["line_items"];

		foreach ($items as $item) {
			$item_id = $item["shop_uid"];
			$quantity = $item["quantity"];
			$order->add_product( get_product( $item_id ), $quantity);
		}

		

		$order->set_address( $address, 'billing' );
		$order->set_address( $address, 'shipping' );
		//$order->payment_complete();
		$order->calculate_totals();
		$order->update_status( 'processing', 'Order created dynamically - ', TRUE);
		$order->update_meta_data('skroutzcode', $data["code"]);
		if ($data["invoice"]) {
		    $order->update_meta_data('timologio2', "Τιμολόγιο");
		    $order->update_meta_data('timologio_drastiriotita', $data["invoice_details"]["profession"]);
		    $order->update_meta_data('timologio_afm', $data["invoice_details"]["vat_number"]);
		    $order->update_meta_data('timologio_doy', $data["invoice_details"]["doy"]);
		}
		    
		$comment = $data["comments"];
		$order->set_customer_note($comment);
		$order->save();
	}

	function register_awaiting_shipment_order_status() {
	    register_post_status( 'wc-awaiting-shipment', array(
	        'label'                     => 'Awaiting shipment',
	        'public'                    => true,
	        'exclude_from_search'       => false,
	        'show_in_admin_all_list'    => true,
	        'show_in_admin_status_list' => true,
	        'label_count'               => _n_noop( 'Awaiting shipment (%s)', 'Awaiting shipment (%s)' )
	    ) );
	}

	function handle_order($request_data ) {
		// Get parameters+
		$params = $request_data->get_params();
		$event_type = $params["event_type"];
		$order = $params["order"];
		if ($event_type == "new_order") {
			$this->create_order($order);
		}
		return $params["event_type"];
		// Check if the request is valid
		if ( $params['api_key'] != get_option( 'obs_woo_api_ext_api_key' ) ) {
			return [ 'error' => 'Invalid request' ];
		}
	}
	
	function handle_custom_query_var( $query, $query_vars ) {
		if ( ! empty( $query_vars['skroutzcode'] ) ) {
			$query['meta_query'][] = array(
				'key' => 'skroutzcode',
				'value' => esc_attr( $query_vars['skroutzcode'] ),
			);
		}

		return $query;
	}
	

	
}

// Init plugin

	$obs_woo_api_ext = new Obs_Woo_Api_Ext();


